// SBZini is a very usefull function for creating INI files instantly
// Just type filename, root, key, value, action and done! For action type 'save' to save or 'restore' to parse a value
//
// This is a save example:
// sbzINI('c:\test.ini','MainTitle1','SubTitle1','1',save);
//
// This is a restore example:
// mainsubvalue1:=sbzINI('c:\test.ini','MainTitle1','SubTitle1','',restore);
//
//2006-2012 by Solon Zenetzis - SBZ systems
//
//June 1, 2012
//http://www.sbzsystems.com
//email: support@sbzsystems.com
//
//This software is provided 'as-is', without any express or implied warranty.
//In no event will the author be held liable for any damages arising from the use of this software.
//Source modification is allowed with the condition that you'll sent us a copy.
//Permission is granted to anyone to use this software for any purpose, including commercial applications, and redistribute it freely.
//The origin of this software must not be misrepresented, you must not claim that you wrote the original software.
//This notice may not be removed or altered from any source distribution.

unit sbzfastini;

interface
uses sysutils, classes;

type grid_col=(save,restore);
function sbzINI(filename_,root_,key_,value_:string;action_:grid_col):string;


implementation

////// SBZ INI FILE  SAVE RESTORE
function sbzINI;
var i,tr:integer;
    prox:string;
    initext:Tstringlist;
begin
initext:=TstringList.Create;
if not FileExists(filename_) then initext.SaveToFile(filename_,TEncoding.UTF8);
initext.LoadFromFile(filename_,TEncoding.UTF8);

if action_=restore then Result:=value_;

tr:=0;
for i:=0 to initext.Count-1 do begin
  prox:=initext.strings[i];
  if (tr>0) and ('['=copy(prox,1,1)) then break;
  if '['+lowercase(root_)+']'=lowercase(copy(prox,1,length(root_)+2)) then tr:=i+1;
  if (tr>0) and (lowercase(key_)+'='=lowercase(copy(prox,1,length(key_)+1))) then begin
          tr:=i;
          if action_=restore then begin
              Result:=copy(prox,length(key_+'=')+1,length(prox)-length(key_+'='));
              if STRempty(Result) then Result:=value_;
              initext.Free;
              exit;
          end;
          initext.Delete(tr);
          break;
  end;
end;

if (tr=0) then begin /////// FIRST TIME
    initext.Add('['+root_+']');
    initext.Add(key_+'='+value_);
end else            //////// NORMAL
    initext.Insert(tr,key_+'='+value_);

initext.SaveToFile( filename_,TEncoding.UTF8);
initext.Free;
end;



end.


















